import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/date_converter.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/add_money/add_money_history_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:viserpay_agent/view/components/column_widget/card_column.dart';

class AddMoneyHistoryBottomSheet {
  static void addMoneyHistoryBottomSheet({required BuildContext context, required int index}) {
    showModalBottomSheet(
        isScrollControlled: true,
        backgroundColor: Colors.transparent,
        context: context,
        isDismissible: true,
        builder: (BuildContext context) {
          return GetBuilder<AddMoneyHistoryController>(
            builder: (controller) => SingleChildScrollView(
              physics: const ClampingScrollPhysics(),
              child: Container(
                  padding: const EdgeInsets.all(20),
                  decoration: const BoxDecoration(color: MyColor.colorWhite, borderRadius: BorderRadius.vertical(top: Radius.circular(20))),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      const BottomSheetHeaderRow(header: MyStrings.addcashInfo),
                      const SizedBox(height: Dimensions.space15),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [CardColumn(header: MyStrings.trxId, body: controller.depositList[index].trx ?? ""), CardColumn(alignmentEnd: true, header: MyStrings.gateWay, body: controller.depositList[index].gateway?.name ?? "-----")],
                      ),
                      const SizedBox(height: Dimensions.space15),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Row(
                                children: [
                                  Text(MyStrings.amount, style: regularSmall.copyWith(color: MyColor.colorBlack.withOpacity(0.6))),
                                  const SizedBox(width: Dimensions.space5),
                                  Text(
                                    "(${controller.currencySym}${Converter.formatNumber(controller.depositList[index].amount ?? "")} + ${Converter.formatNumber(controller.depositList[index].charge ?? "")})",
                                    style: regularSmall.copyWith(color: MyColor.colorRed, fontWeight: FontWeight.w500),
                                  )
                                ],
                              ),
                              const SizedBox(height: Dimensions.space5),
                              Text("${Converter.formatNumber(controller.depositList[index].finalAmo ?? "")} ${controller.currency}", style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w500), overflow: TextOverflow.ellipsis)
                            ],
                          ),
                          CardColumn(
                            alignmentEnd: true,
                            header: MyStrings.date,
                            body: DateConverter.nextReturnTime(controller.depositList[index].createdAt ?? ""),
                          )
                        ],
                      ),
                      const SizedBox(height: Dimensions.space20),
                    ],
                  )),
            ),
          );
        });
  }
}
